import random
import math
import util
import sys

sys.path.append("d:\\demos\\demo")

from demoscript import *

sched = SchedulerSingleton_instance() # setup scheduler


modplayer=32
addMapping(modplayer,6,"bass")


# --

text = util.SimpleScene("d:\\demos\\demo\\text.lzma")
text.speed = FixedSlider(4500, 4500)

for mat in text.getScene().getMaterials():
  mat.glow = 1.0

ps = util.SimpleScene("d:\\demos\\demo\\black.lzma")
ps.speed = FixedSlider(4500, 4500)

for mat in ps.getScene().getMaterials():
  mat.glow = 0

# -----------------

endtext = util.SimpleScene("d:\\demos\\demo\\endtext.lzma")
endtext.speed = FixedSlider(4500, 4500)

for mat in endtext.getScene().getMaterials():
  mat.glow = 1.0

columns = util.SimpleScene("d:\\demos\\demo\\art.lzma", loop = True)
columns.speed = FixedSlider(2500, 2500)

for mat in columns.getScene().getMaterials():
  mat.glow = 1

ktime = 0.0
gtime = 0.0
gmode = 1
def colCallBack(scene, event = "none"):


  
  t = getTime()
  global gtime
  global gmode
  gtime += 1

  if gtime > 300:
    
    gtime = 0
    gmode = random.random() > 0.5

  c = 0
  
  if gmode == 0:
    c = math.cos(t*4.432)*0.3 + 0.3 + random.random() * 0.1 + 0.05

  else:
    c = random.random()


  if t > 49:
    c *= (((84-49) - (t-49)) / (84-49)) + 0.2
  
  c = math.fabs(c)
   

  for mat in scene.getScene().getMaterials():
    mat.glow = c
  
  global ktime
  ktime += 1
  if ktime > 200:
    ktime = 0
    if random.random() < 0.5:
      scene.reset()
    scene.nextCamera()
    


columns.callBacks.append([colCallBack])


columns2 = util.SimpleScene("d:\\demos\\demo\\art2.lzma", loop = True)
columns2.speed = FixedSlider(2500, 2500)
#columns2.callBacks.append([colCallBack])

for mat in columns2.getScene().getMaterials():
  mat.glow = 1


noise = util.SimpleNoise()
distort =  util.SimpleDistort()


glow = util.SimpleGlow()
glow.mix = FixedSlider(1, 1)
glow.setAdditive(1)
glow.spread = FixedSlider(2,2)

noise.connectOutput(glow, "in")

#distort.connectOutput(noise, "in")

xfade = XFade()

gamma = util.CoolGamma()
glow.connectOutput(gamma, "in")


sched.schedule(0, 10, text, SI_A, 0)
sched.schedule(8, 2, xfade, SI_MIX, 0)
sched.schedule(8, 34-8, columns, SI_B, 0) # first scene

sched.schedule(29, 8,xfade, SI_MIX, 0)

sched.schedule(29, 55-29, columns2, SI_A, 0) # second scene
sched.schedule(50, 85-50, columns, SI_B, 0) # first scene

sched.schedule(50, 5, xfade, SI_MIX, 0)

sched.schedule(83, 2, xfade, SI_MIX, 0)

sched.schedule(83, 8, ps, SI_A, 0)

sched.schedule(89, 2, xfade, SI_MIX, 0)
sched.schedule(89, 12, endtext, SI_B, 0)

sched.schedule(89+10, 2, xfade, SI_MIX, 0)
sched.schedule(89+10, 2, ps, SI_A, 0)



sched.schedule(0, 93+12, gamma, SI_POST, 0)

playSong("d:\\demos\\demo\\poep.wma")
seek(0)



